/*
 * Decompiled with CFR 0.152.
 */
package com.finallion.graveyard.biomes.features.trees;

import com.finallion.graveyard.biomes.features.trees.config.TGTreeFeatureConfig;
import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.feature.Feature;

public abstract class BaseSpruceTree
extends Feature<TGTreeFeatureConfig> {
    public BaseSpruceTree(Codec<TGTreeFeatureConfig> configCodec) {
        super(configCodec);
    }

    public boolean place(ISeedReader world, ChunkGenerator generator, Random random, BlockPos pos, TGTreeFeatureConfig config) {
        return false;
    }

    public void setLeaves(ISeedReader world, BlockPos pos, BlockState state) {
        if (BaseSpruceTree.canReplace((IWorldGenerationBaseReader)world, pos)) {
            world.func_180501_a(pos, state, 2);
        }
    }

    public void setLeavesRandomized(ISeedReader world, BlockPos pos, BlockState state, int chance) {
        if (BaseSpruceTree.canReplace((IWorldGenerationBaseReader)world, pos) && world.func_201674_k().nextInt(chance) == 0) {
            world.func_180501_a(pos, state, 2);
        }
    }

    public void setBranchRandomized(ISeedReader world, BlockPos pos, BlockState state, int chance) {
        if (BaseSpruceTree.canReplace((IWorldGenerationBaseReader)world, pos) && world.func_201674_k().nextInt(chance) == 0) {
            world.func_180501_a(pos, state, 2);
        }
    }

    public static boolean canReplace(IWorldGenerationBaseReader p_236404_0_, BlockPos p_236404_1_) {
        return BaseSpruceTree.isAirOrLeaves(p_236404_0_, p_236404_1_) || BaseSpruceTree.isReplaceablePlant(p_236404_0_, p_236404_1_) || BaseSpruceTree.isWater(p_236404_0_, p_236404_1_);
    }

    private static boolean isWater(IWorldGenerationBaseReader p_236416_0_, BlockPos p_236416_1_) {
        return p_236416_0_.func_217375_a(p_236416_1_, p_236413_0_ -> p_236413_0_.func_203425_a(Blocks.field_150355_j));
    }

    public static boolean isAirOrLeaves(IWorldGenerationBaseReader p_236412_0_, BlockPos p_236412_1_) {
        return p_236412_0_.func_217375_a(p_236412_1_, p_236411_0_ -> p_236411_0_.func_196958_f() || p_236411_0_.func_235714_a_((ITag)BlockTags.field_206952_E));
    }

    private static boolean isReplaceablePlant(IWorldGenerationBaseReader p_236419_0_, BlockPos p_236419_1_) {
        return p_236419_0_.func_217375_a(p_236419_1_, p_236406_0_ -> {
            Material material = p_236406_0_.func_185904_a();
            return material == Material.field_151582_l;
        });
    }

    public void generateBranchesOne(ISeedReader world, BlockPos pos, int chance, TGTreeFeatureConfig config) {
        this.setBranchRandomized(world, pos.func_177982_a(1, 0, 0), (BlockState)config.woodState.func_206870_a((Property)BlockStateProperties.field_208148_A, (Comparable)Direction.Axis.X), chance);
        this.setBranchRandomized(world, pos.func_177982_a(0, 0, 1), (BlockState)config.woodState.func_206870_a((Property)BlockStateProperties.field_208148_A, (Comparable)Direction.Axis.Z), chance);
        this.setBranchRandomized(world, pos.func_177982_a(-1, 0, 0), (BlockState)config.woodState.func_206870_a((Property)BlockStateProperties.field_208148_A, (Comparable)Direction.Axis.X), chance);
        this.setBranchRandomized(world, pos.func_177982_a(0, 0, -1), (BlockState)config.woodState.func_206870_a((Property)BlockStateProperties.field_208148_A, (Comparable)Direction.Axis.Z), chance);
    }

    public void generateBranchesTwo(ISeedReader world, BlockPos pos, int chance, TGTreeFeatureConfig config) {
        this.setBranchRandomized(world, pos.func_177982_a(1, 0, 0), (BlockState)config.woodState.func_206870_a((Property)BlockStateProperties.field_208148_A, (Comparable)Direction.Axis.X), chance);
        this.setBranchRandomized(world, pos.func_177982_a(0, 0, 1), (BlockState)config.woodState.func_206870_a((Property)BlockStateProperties.field_208148_A, (Comparable)Direction.Axis.Z), chance);
        this.setBranchRandomized(world, pos.func_177982_a(-1, 0, 0), (BlockState)config.woodState.func_206870_a((Property)BlockStateProperties.field_208148_A, (Comparable)Direction.Axis.X), chance);
        this.setBranchRandomized(world, pos.func_177982_a(0, 0, -1), (BlockState)config.woodState.func_206870_a((Property)BlockStateProperties.field_208148_A, (Comparable)Direction.Axis.Z), chance);
        this.setBranchRandomized(world, pos.func_177982_a(2, 0, 0), (BlockState)config.woodState.func_206870_a((Property)BlockStateProperties.field_208148_A, (Comparable)Direction.Axis.X), chance);
        this.setBranchRandomized(world, pos.func_177982_a(0, 0, 2), (BlockState)config.woodState.func_206870_a((Property)BlockStateProperties.field_208148_A, (Comparable)Direction.Axis.Z), chance);
        this.setBranchRandomized(world, pos.func_177982_a(-2, 0, 0), (BlockState)config.woodState.func_206870_a((Property)BlockStateProperties.field_208148_A, (Comparable)Direction.Axis.X), chance);
        this.setBranchRandomized(world, pos.func_177982_a(0, 0, -2), (BlockState)config.woodState.func_206870_a((Property)BlockStateProperties.field_208148_A, (Comparable)Direction.Axis.Z), chance);
    }

    public void randomSpreadOne(ISeedReader world, BlockPos pos, boolean beSquare, int chance, TGTreeFeatureConfig config) {
        this.setLeavesRandomized(world, pos.func_177982_a(1, 0, 0), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(0, 0, 1), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(-1, 0, 0), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(0, 0, -1), config.leafState, chance);
    }

    public void randomSpreadTwo(ISeedReader world, BlockPos pos, boolean beSquare, int chance, TGTreeFeatureConfig config) {
        this.setLeavesRandomized(world, pos.func_177982_a(1, 0, 0), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(0, 0, 1), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(-1, 0, 0), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(0, 0, -1), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(-1, 0, -1), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(1, 0, 1), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(-1, 0, 1), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(1, 0, -1), config.leafState, chance);
        if (!beSquare) {
            this.setLeavesRandomized(world, pos.func_177982_a(2, 0, 0), config.leafState, chance);
            this.setLeavesRandomized(world, pos.func_177982_a(0, 0, 2), config.leafState, chance);
            this.setLeavesRandomized(world, pos.func_177982_a(-2, 0, 0), config.leafState, chance);
            this.setLeavesRandomized(world, pos.func_177982_a(0, 0, -2), config.leafState, chance);
        }
    }

    public void randomSpreadThree(ISeedReader world, BlockPos pos, boolean beSquare, int chance, TGTreeFeatureConfig config) {
        this.setLeavesRandomized(world, pos.func_177982_a(1, 0, 0), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(0, 0, 1), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(-1, 0, 0), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(0, 0, -1), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(-1, 0, -1), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(1, 0, 1), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(-1, 0, 1), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(1, 0, -1), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(2, 0, 0), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(0, 0, 2), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(-2, 0, 0), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(0, 0, -2), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(2, 0, 1), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(1, 0, 2), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(-2, 0, 1), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(1, 0, -2), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(2, 0, -1), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(-1, 0, 2), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(-2, 0, -1), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(-1, 0, -2), config.leafState, chance);
        if (!beSquare) {
            this.setLeavesRandomized(world, pos.func_177982_a(3, 0, 0), config.leafState, chance);
            this.setLeavesRandomized(world, pos.func_177982_a(0, 0, 3), config.leafState, chance);
            this.setLeavesRandomized(world, pos.func_177982_a(-3, 0, 0), config.leafState, chance);
            this.setLeavesRandomized(world, pos.func_177982_a(0, 0, -3), config.leafState, chance);
        }
    }

    public void randomSpreadFour(ISeedReader world, BlockPos pos, boolean beSquare, int chance, TGTreeFeatureConfig config) {
        this.setLeavesRandomized(world, pos.func_177982_a(1, 0, 0), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(0, 0, 1), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(-1, 0, 0), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(0, 0, -1), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(-1, 0, -1), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(1, 0, 1), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(-1, 0, 1), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(1, 0, -1), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(2, 0, 0), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(0, 0, 2), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(-2, 0, 0), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(0, 0, -2), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(2, 0, 1), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(1, 0, 2), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(-2, 0, 1), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(1, 0, -2), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(2, 0, -1), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(-1, 0, 2), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(-2, 0, -1), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(-1, 0, -2), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(2, 0, 2), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(-2, 0, 2), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(-2, 0, -2), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(2, 0, -2), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(3, 0, 0), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(0, 0, 3), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(-3, 0, 0), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(0, 0, -3), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(3, 0, 1), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(1, 0, 3), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(-3, 0, 1), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(1, 0, -3), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(3, 0, -1), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(-1, 0, 3), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(-3, 0, -1), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(-1, 0, -3), config.leafState, chance);
        if (!beSquare) {
            this.setLeavesRandomized(world, pos.func_177982_a(4, 0, 0), config.leafState, chance);
            this.setLeavesRandomized(world, pos.func_177982_a(0, 0, 4), config.leafState, chance);
            this.setLeavesRandomized(world, pos.func_177982_a(-4, 0, 0), config.leafState, chance);
            this.setLeavesRandomized(world, pos.func_177982_a(0, 0, -4), config.leafState, chance);
        }
    }

    public void randomSpreadFive(ISeedReader world, BlockPos pos, boolean beSquare, int chance, TGTreeFeatureConfig config) {
        this.setLeavesRandomized(world, pos.func_177982_a(1, 0, 0), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(0, 0, 1), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(-1, 0, 0), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(0, 0, -1), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(-1, 0, -1), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(1, 0, 1), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(-1, 0, 1), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(1, 0, -1), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(2, 0, 0), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(0, 0, 2), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(-2, 0, 0), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(0, 0, -2), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(2, 0, 1), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(1, 0, 2), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(-2, 0, 1), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(1, 0, -2), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(2, 0, -1), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(-1, 0, 2), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(-2, 0, -1), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(-1, 0, -2), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(2, 0, 2), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(-2, 0, 2), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(-2, 0, -2), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(2, 0, -2), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(3, 0, 0), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(0, 0, 3), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(-3, 0, 0), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(0, 0, -3), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(3, 0, 1), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(1, 0, 3), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(-3, 0, 1), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(1, 0, -3), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(3, 0, -1), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(-1, 0, 3), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(-3, 0, -1), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(-1, 0, -3), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(3, 0, 2), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(2, 0, 3), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(-3, 0, 2), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(2, 0, -3), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(3, 0, -2), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(-2, 0, 3), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(-3, 0, -2), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(-2, 0, -3), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(4, 0, 0), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(0, 0, 4), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(-4, 0, 0), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(0, 0, -4), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(4, 0, 1), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(1, 0, 4), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(-4, 0, 1), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(1, 0, -4), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(4, 0, -1), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(-1, 0, 4), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(-4, 0, -1), config.leafState, chance);
        this.setLeavesRandomized(world, pos.func_177982_a(-1, 0, -4), config.leafState, chance);
        if (!beSquare) {
            this.setLeavesRandomized(world, pos.func_177982_a(5, 0, 0), config.leafState, chance);
            this.setLeavesRandomized(world, pos.func_177982_a(0, 0, 5), config.leafState, chance);
            this.setLeavesRandomized(world, pos.func_177982_a(-5, 0, 0), config.leafState, chance);
            this.setLeavesRandomized(world, pos.func_177982_a(0, 0, -5), config.leafState, chance);
        }
    }

    public void generateOneStar(ISeedReader world, BlockPos pos, boolean beSquare, TGTreeFeatureConfig config) {
        this.setLeaves(world, pos.func_177982_a(1, 0, 0), config.leafState);
        this.setLeaves(world, pos.func_177982_a(0, 0, 1), config.leafState);
        this.setLeaves(world, pos.func_177982_a(-1, 0, 0), config.leafState);
        this.setLeaves(world, pos.func_177982_a(0, 0, -1), config.leafState);
    }

    public void generateTwoStar(ISeedReader world, BlockPos pos, boolean beSquare, TGTreeFeatureConfig config) {
        this.setLeaves(world, pos.func_177982_a(1, 0, 0), config.leafState);
        this.setLeaves(world, pos.func_177982_a(0, 0, 1), config.leafState);
        this.setLeaves(world, pos.func_177982_a(-1, 0, 0), config.leafState);
        this.setLeaves(world, pos.func_177982_a(0, 0, -1), config.leafState);
        this.setLeaves(world, pos.func_177982_a(-1, 0, -1), config.leafState);
        this.setLeaves(world, pos.func_177982_a(1, 0, 1), config.leafState);
        this.setLeaves(world, pos.func_177982_a(-1, 0, 1), config.leafState);
        this.setLeaves(world, pos.func_177982_a(1, 0, -1), config.leafState);
        if (!beSquare) {
            this.setLeaves(world, pos.func_177982_a(2, 0, 0), config.leafState);
            this.setLeaves(world, pos.func_177982_a(0, 0, 2), config.leafState);
            this.setLeaves(world, pos.func_177982_a(-2, 0, 0), config.leafState);
            this.setLeaves(world, pos.func_177982_a(0, 0, -2), config.leafState);
        }
    }

    public void generateThreeStar(ISeedReader world, BlockPos pos, boolean beSquare, TGTreeFeatureConfig config) {
        this.setLeaves(world, pos.func_177982_a(1, 0, 0), config.leafState);
        this.setLeaves(world, pos.func_177982_a(0, 0, 1), config.leafState);
        this.setLeaves(world, pos.func_177982_a(-1, 0, 0), config.leafState);
        this.setLeaves(world, pos.func_177982_a(0, 0, -1), config.leafState);
        this.setLeaves(world, pos.func_177982_a(-1, 0, -1), config.leafState);
        this.setLeaves(world, pos.func_177982_a(1, 0, 1), config.leafState);
        this.setLeaves(world, pos.func_177982_a(-1, 0, 1), config.leafState);
        this.setLeaves(world, pos.func_177982_a(1, 0, -1), config.leafState);
        this.setLeaves(world, pos.func_177982_a(2, 0, 0), config.leafState);
        this.setLeaves(world, pos.func_177982_a(0, 0, 2), config.leafState);
        this.setLeaves(world, pos.func_177982_a(-2, 0, 0), config.leafState);
        this.setLeaves(world, pos.func_177982_a(0, 0, -2), config.leafState);
        this.setLeaves(world, pos.func_177982_a(2, 0, 1), config.leafState);
        this.setLeaves(world, pos.func_177982_a(1, 0, 2), config.leafState);
        this.setLeaves(world, pos.func_177982_a(-2, 0, 1), config.leafState);
        this.setLeaves(world, pos.func_177982_a(1, 0, -2), config.leafState);
        this.setLeaves(world, pos.func_177982_a(2, 0, -1), config.leafState);
        this.setLeaves(world, pos.func_177982_a(-1, 0, 2), config.leafState);
        this.setLeaves(world, pos.func_177982_a(-2, 0, -1), config.leafState);
        this.setLeaves(world, pos.func_177982_a(-1, 0, -2), config.leafState);
        if (!beSquare) {
            this.setLeaves(world, pos.func_177982_a(3, 0, 0), config.leafState);
            this.setLeaves(world, pos.func_177982_a(0, 0, 3), config.leafState);
            this.setLeaves(world, pos.func_177982_a(-3, 0, 0), config.leafState);
            this.setLeaves(world, pos.func_177982_a(0, 0, -3), config.leafState);
        }
    }

    public void generateFourStar(ISeedReader world, BlockPos pos, boolean beSquare, TGTreeFeatureConfig config) {
        this.setLeaves(world, pos.func_177982_a(1, 0, 0), config.leafState);
        this.setLeaves(world, pos.func_177982_a(0, 0, 1), config.leafState);
        this.setLeaves(world, pos.func_177982_a(-1, 0, 0), config.leafState);
        this.setLeaves(world, pos.func_177982_a(0, 0, -1), config.leafState);
        this.setLeaves(world, pos.func_177982_a(-1, 0, -1), config.leafState);
        this.setLeaves(world, pos.func_177982_a(1, 0, 1), config.leafState);
        this.setLeaves(world, pos.func_177982_a(-1, 0, 1), config.leafState);
        this.setLeaves(world, pos.func_177982_a(1, 0, -1), config.leafState);
        this.setLeaves(world, pos.func_177982_a(2, 0, 0), config.leafState);
        this.setLeaves(world, pos.func_177982_a(0, 0, 2), config.leafState);
        this.setLeaves(world, pos.func_177982_a(-2, 0, 0), config.leafState);
        this.setLeaves(world, pos.func_177982_a(0, 0, -2), config.leafState);
        this.setLeaves(world, pos.func_177982_a(2, 0, 1), config.leafState);
        this.setLeaves(world, pos.func_177982_a(1, 0, 2), config.leafState);
        this.setLeaves(world, pos.func_177982_a(-2, 0, 1), config.leafState);
        this.setLeaves(world, pos.func_177982_a(1, 0, -2), config.leafState);
        this.setLeaves(world, pos.func_177982_a(2, 0, -1), config.leafState);
        this.setLeaves(world, pos.func_177982_a(-1, 0, 2), config.leafState);
        this.setLeaves(world, pos.func_177982_a(-2, 0, -1), config.leafState);
        this.setLeaves(world, pos.func_177982_a(-1, 0, -2), config.leafState);
        this.setLeaves(world, pos.func_177982_a(2, 0, 2), config.leafState);
        this.setLeaves(world, pos.func_177982_a(-2, 0, 2), config.leafState);
        this.setLeaves(world, pos.func_177982_a(-2, 0, -2), config.leafState);
        this.setLeaves(world, pos.func_177982_a(2, 0, -2), config.leafState);
        this.setLeaves(world, pos.func_177982_a(3, 0, 0), config.leafState);
        this.setLeaves(world, pos.func_177982_a(0, 0, 3), config.leafState);
        this.setLeaves(world, pos.func_177982_a(-3, 0, 0), config.leafState);
        this.setLeaves(world, pos.func_177982_a(0, 0, -3), config.leafState);
        this.setLeaves(world, pos.func_177982_a(3, 0, 1), config.leafState);
        this.setLeaves(world, pos.func_177982_a(1, 0, 3), config.leafState);
        this.setLeaves(world, pos.func_177982_a(-3, 0, 1), config.leafState);
        this.setLeaves(world, pos.func_177982_a(1, 0, -3), config.leafState);
        this.setLeaves(world, pos.func_177982_a(3, 0, -1), config.leafState);
        this.setLeaves(world, pos.func_177982_a(-1, 0, 3), config.leafState);
        this.setLeaves(world, pos.func_177982_a(-3, 0, -1), config.leafState);
        this.setLeaves(world, pos.func_177982_a(-1, 0, -3), config.leafState);
        if (!beSquare) {
            this.setLeaves(world, pos.func_177982_a(4, 0, 0), config.leafState);
            this.setLeaves(world, pos.func_177982_a(0, 0, 4), config.leafState);
            this.setLeaves(world, pos.func_177982_a(-4, 0, 0), config.leafState);
            this.setLeaves(world, pos.func_177982_a(0, 0, -4), config.leafState);
        }
    }

    public void generateFiveStar(ISeedReader world, BlockPos pos, boolean beSquare, TGTreeFeatureConfig config) {
        this.setLeaves(world, pos.func_177982_a(1, 0, 0), config.leafState);
        this.setLeaves(world, pos.func_177982_a(0, 0, 1), config.leafState);
        this.setLeaves(world, pos.func_177982_a(-1, 0, 0), config.leafState);
        this.setLeaves(world, pos.func_177982_a(0, 0, -1), config.leafState);
        this.setLeaves(world, pos.func_177982_a(-1, 0, -1), config.leafState);
        this.setLeaves(world, pos.func_177982_a(1, 0, 1), config.leafState);
        this.setLeaves(world, pos.func_177982_a(-1, 0, 1), config.leafState);
        this.setLeaves(world, pos.func_177982_a(1, 0, -1), config.leafState);
        this.setLeaves(world, pos.func_177982_a(2, 0, 0), config.leafState);
        this.setLeaves(world, pos.func_177982_a(0, 0, 2), config.leafState);
        this.setLeaves(world, pos.func_177982_a(-2, 0, 0), config.leafState);
        this.setLeaves(world, pos.func_177982_a(0, 0, -2), config.leafState);
        this.setLeaves(world, pos.func_177982_a(2, 0, 1), config.leafState);
        this.setLeaves(world, pos.func_177982_a(1, 0, 2), config.leafState);
        this.setLeaves(world, pos.func_177982_a(-2, 0, 1), config.leafState);
        this.setLeaves(world, pos.func_177982_a(1, 0, -2), config.leafState);
        this.setLeaves(world, pos.func_177982_a(2, 0, -1), config.leafState);
        this.setLeaves(world, pos.func_177982_a(-1, 0, 2), config.leafState);
        this.setLeaves(world, pos.func_177982_a(-2, 0, -1), config.leafState);
        this.setLeaves(world, pos.func_177982_a(-1, 0, -2), config.leafState);
        this.setLeaves(world, pos.func_177982_a(2, 0, 2), config.leafState);
        this.setLeaves(world, pos.func_177982_a(-2, 0, 2), config.leafState);
        this.setLeaves(world, pos.func_177982_a(-2, 0, -2), config.leafState);
        this.setLeaves(world, pos.func_177982_a(2, 0, -2), config.leafState);
        this.setLeaves(world, pos.func_177982_a(3, 0, 0), config.leafState);
        this.setLeaves(world, pos.func_177982_a(0, 0, 3), config.leafState);
        this.setLeaves(world, pos.func_177982_a(-3, 0, 0), config.leafState);
        this.setLeaves(world, pos.func_177982_a(0, 0, -3), config.leafState);
        this.setLeaves(world, pos.func_177982_a(3, 0, 1), config.leafState);
        this.setLeaves(world, pos.func_177982_a(1, 0, 3), config.leafState);
        this.setLeaves(world, pos.func_177982_a(-3, 0, 1), config.leafState);
        this.setLeaves(world, pos.func_177982_a(1, 0, -3), config.leafState);
        this.setLeaves(world, pos.func_177982_a(3, 0, -1), config.leafState);
        this.setLeaves(world, pos.func_177982_a(-1, 0, 3), config.leafState);
        this.setLeaves(world, pos.func_177982_a(-3, 0, -1), config.leafState);
        this.setLeaves(world, pos.func_177982_a(-1, 0, -3), config.leafState);
        this.setLeaves(world, pos.func_177982_a(3, 0, 2), config.leafState);
        this.setLeaves(world, pos.func_177982_a(2, 0, 3), config.leafState);
        this.setLeaves(world, pos.func_177982_a(-3, 0, 2), config.leafState);
        this.setLeaves(world, pos.func_177982_a(2, 0, -3), config.leafState);
        this.setLeaves(world, pos.func_177982_a(3, 0, -2), config.leafState);
        this.setLeaves(world, pos.func_177982_a(-2, 0, 3), config.leafState);
        this.setLeaves(world, pos.func_177982_a(-3, 0, -2), config.leafState);
        this.setLeaves(world, pos.func_177982_a(-2, 0, -3), config.leafState);
        this.setLeaves(world, pos.func_177982_a(4, 0, 0), config.leafState);
        this.setLeaves(world, pos.func_177982_a(0, 0, 4), config.leafState);
        this.setLeaves(world, pos.func_177982_a(-4, 0, 0), config.leafState);
        this.setLeaves(world, pos.func_177982_a(0, 0, -4), config.leafState);
        this.setLeaves(world, pos.func_177982_a(4, 0, 1), config.leafState);
        this.setLeaves(world, pos.func_177982_a(1, 0, 4), config.leafState);
        this.setLeaves(world, pos.func_177982_a(-4, 0, 1), config.leafState);
        this.setLeaves(world, pos.func_177982_a(1, 0, -4), config.leafState);
        this.setLeaves(world, pos.func_177982_a(4, 0, -1), config.leafState);
        this.setLeaves(world, pos.func_177982_a(-1, 0, 4), config.leafState);
        this.setLeaves(world, pos.func_177982_a(-4, 0, -1), config.leafState);
        this.setLeaves(world, pos.func_177982_a(-1, 0, -4), config.leafState);
        if (!beSquare) {
            this.setLeaves(world, pos.func_177982_a(5, 0, 0), config.leafState);
            this.setLeaves(world, pos.func_177982_a(0, 0, 5), config.leafState);
            this.setLeaves(world, pos.func_177982_a(-5, 0, 0), config.leafState);
            this.setLeaves(world, pos.func_177982_a(0, 0, -5), config.leafState);
        }
    }
}

